const server = "http://localhost:8785";

async function getVar(name){
  try{
    const res = await fetch(`${server}/?variable=${encodeURIComponent(name)}`, { cache: "no-store" });
    if(!res.ok) throw new Error(res.status);
    const raw = (await res.text()).trim();
    const num = Number(raw.replace(',', '.'));
    return Number.isFinite(num) ? num : raw;
  }catch(e){
    return null;
  }
}

const fmt = {
  pad(n, len){ return String(Math.trunc(Math.abs(n))).padStart(len, '0'); },
  temp(v){ return v==null ? "0000°C" : `${fmt.pad(v,4)}°C`; },
  press(v){ return v==null ? "000 BAR" : `${fmt.pad(v,3)} BAR`; },
  volume(v){ return v==null ? "000000" : fmt.pad(v,6); }
};

async function updateCore(){
  const [t, p, v, state, ready] = await Promise.all([
    getVar("CORE_TEMP"),
    getVar("CORE_PRESSURE"),
    getVar("CORE_PRIMARY_CIRCUIT_COOLING_TANK_VOLUME"),
    getVar("CORE_STATE"),
    getVar("CORE_READY_FOR_START")
  ]);
  document.getElementById("core-temp").textContent = fmt.temp(t);
  document.getElementById("core-press").textContent = fmt.press(p);
  document.getElementById("core-vol").textContent = fmt.volume(v);
  document.getElementById("core-state").textContent = `STATE: ${state ?? "—"}`;
  document.getElementById("core-ready").textContent = `READY: ${ready ?? "—"}`;
}

function refresh(){
  updateCore();
  // сюда добавишь вызовы updatePressurizer(), updateSteamGen() и т.д.
}

refresh();
setInterval(refresh, 2000);
